<?php
// $Header: /cvsroot/html2ps/css.defaults.inc.php,v 1.38 2006/05/27 15:33:27 Konstantin Exp $

global $g_css_defaults;
$g_css_defaults = array(
                        array(array(SELECTOR_SEQUENCE, array(array(SELECTOR_TAG, "a"),
                                                             array(SELECTOR_PSEUDOCLASS_LINK))),
                              array("color" => "blue", "text-decoration" => "underline")),
                        array(array(SELECTOR_TAG, "address"),   array("display" => "block", 
                                                                      "font-style" => "italic")),
                        array(array(SELECTOR_TAG, "applet") ,   array("display" => "none")),
                        array(array(SELECTOR_TAG, "area") ,     array("display" => "none")),
                        array(array(SELECTOR_TAG, "b") ,        array("font-weight" => "bold")),
                        array(array(SELECTOR_TAG, "big"),       array("font-size" => "1.2em")),
                        array(array(SELECTOR_TAG, "blockquote"),array("display" => "block", 
                                                                      "margin" => "1em 40px")),
                        array(array(SELECTOR_TAG, "body"),      array("display" => "-body", 
                                                                      "margin" => "8px",
                                                                      "line-height" => "1.1",
                                                                      "border" => "none")),
                        array(array(SELECTOR_TAG, "center"),    array("display" => "block", 
                                                                      "text-align" => "center",
                                                                      "-align" => "center")),
                        array(array(SELECTOR_TAG, "cite")      ,array("font-style" => "italic")),
                        array(array(SELECTOR_TAG, "code")      ,array("font-family" => "monospace")),
                        array(array(SELECTOR_TAG, "col")       ,array("display" => "none")),
                        array(array(SELECTOR_TAG, "colgroup")  ,array("display" => "none")),                        
                        array(array(SELECTOR_TAG, "dd"),        array("display" => "block", 
                                                                      "padding-left" => "40px")),
                        array(array(SELECTOR_TAG, "dfn")       ,array("font-style" => "italic")),
                        array(array(SELECTOR_TAG, "div"),       array("display" => "block")),
                        array(array(SELECTOR_TAG, "dir"),       array("margin-left" => "1em")),
                        array(array(SELECTOR_TAG, "dl"),        array("display" => "block", 
                                                                      "margin" => "1em 0")),
                        array(array(SELECTOR_TAG, "dt"),        array("display" => "block")),
                        array(array(SELECTOR_TAG, "em")        ,array("font-style" => "italic")),
                        array(array(SELECTOR_TAG, "embed")     ,array("display" => "block")),
                        array(array(SELECTOR_TAG, "fieldset")  ,array("display" => "block", 
                                                                      "border" => "solid black 1px", 
                                                                      "margin-left" => "2px", "margin-right" => "2px", "padding" => "0.35em 0.625em 0.75em")),
                        array(array(SELECTOR_TAG, "form"),      array("display" => "-form")),
                        array(array(SELECTOR_TAG, "frame"),     array("display" => "-frame", 
                                                                      "position" => "absolute", 
                                                                      "border" => "solid black 2px")),
                        array(array(SELECTOR_TAG, "frameset"),  array("display" => "-frameset")),                        
                        array(array(SELECTOR_TAG, "h1")        ,array("display" => "block",
                                                                      "font-size"   => "2em",    
                                                                      "font-weight" => "bold", 
                                                                      "margin" => ".67em 0")),
                        array(array(SELECTOR_TAG, "h2")        ,array("display" => "block", 
                                                                      "font-size"   => "1.5em",  
                                                                      "font-weight" => "bold", 
                                                                      "margin" => ".83em 0")),
                        array(array(SELECTOR_TAG, "h3")        ,array("display" => "block", 
                                                                      "font-size"   => "1.17em",
                                                                      "font-weight" => "bold", 
                                                                      "margin" => "1em 0")),
                        array(array(SELECTOR_TAG, "h4")        ,array("display" => "block", 
                                                                      "font-weight" => "bold",   
                                                                      "margin"      => "1.33em 0")),
                        array(array(SELECTOR_TAG, "h5")        ,array("display" => "block", 
                                                                      "font-size"   => "0.83em", 
                                                                      "font-weight" => "bold", 
                                                                      "margin" => "1.67m 0")),
                        array(array(SELECTOR_TAG, "h6")        ,array("display" => "block", 
                                                                      "font-size" => "0.67em",
                                                                      "font-weight" => "bold",
                                                                      "margin" => "2.33em 0")),
                        array(array(SELECTOR_TAG, "head")      ,array("display" => "none")),
                        array(array(SELECTOR_TAG, "hr")        ,array("display" => "block", 
                                                                      "margin" => "0.5em auto 0.5em auto", 
                                                                      "height" => "1px", 
                                                                      "border" => "0.1pt solid black")),
                        // We use this non-standard display value to avoid generating box for HTML tag; 
                        // display: none and visibility: hidden are not the alternatives, as they cause the whole 
                        // content of the page to be hidden
                        array(array(SELECTOR_TAG, "html")      ,array("display" => "-html")),
                        array(array(SELECTOR_TAG, "i") ,        array("font-style" => "italic",
                                                                      "display" => "inline")),
                        array(array(SELECTOR_TAG, "iframe"),    array("display" => "-iframe", 
                                                                      "border" => "solid black 2px",
                                                                      "padding" => "3px", 
                                                                      "overflow" => "hidden",
                                                                      "width" => "300px", 
                                                                      "height" => "150px")),
                        array(array(SELECTOR_TAG, "img"),       array("display" => "-image")),
                        array(array(SELECTOR_TAG, "input"),     array("display" => "-text", 
                                                                      "padding" => "1pt", 
                                                                      "margin" => "1px", 
                                                                      "background-color" => "white", 
                                                                      "border" => "black inset 2px", 
                                                                      "line-height" => 1)),
                        array(array(SELECTOR_SEQUENCE, array(array(SELECTOR_TAG, "input"),
                                                             array(SELECTOR_ATTR_VALUE, "type", "password"))),
                              array("display" => "-password")),
                        array(array(SELECTOR_TAG, "button"),
                              array("display" => "-button", 
                                    "text-align" => "center", 
                                    "border" => "outset 2px",
                                    "background-color" => "#eeeeee")),
                        array(array(SELECTOR_SEQUENCE, array(array(SELECTOR_TAG, "input"),
                                                             array(SELECTOR_ATTR_VALUE, "type", "button"))),
                              array("display" => "-button", 
                                    "text-align" => "center", 
                                    "border" => "outset 2px",
                                    "background-color" => "#eeeeee")),
                        array(array(SELECTOR_SEQUENCE, array(array(SELECTOR_TAG, "input"),
                                                             array(SELECTOR_ATTR_VALUE, "type", "checkbox"))),
                              array("display" => "-checkbox")),
                        array(array(SELECTOR_SEQUENCE, array(array(SELECTOR_TAG, "input"),
                                                             array(SELECTOR_ATTR_VALUE, "type", "hidden"))),
                              array("display" => "none")),
                        array(array(SELECTOR_SEQUENCE, array(array(SELECTOR_TAG, "input"),
                                                             array(SELECTOR_ATTR_VALUE, "type", "image"))),
                              array("display" => "-button-image",
                                    "border" => "none 0px", 
                                    "background-color" => "transparent")),
                        array(array(SELECTOR_SEQUENCE, array(array(SELECTOR_TAG, "input"),
                                                             array(SELECTOR_ATTR_VALUE, "type", "radio"))),
                              array("display" => "-radio")),
                        array(array(SELECTOR_SEQUENCE, 
                                    array(array(SELECTOR_TAG, "input"),
                                          array(SELECTOR_ATTR_VALUE, "type", "reset"))),
                              array("display" => "-button-reset", 
                                    "text-align" => "center", 
                                    "border" => "outset 2px",
                                    "background-color" => "#eeeeee")),
                        array(array(SELECTOR_SEQUENCE, 
                                    array(array(SELECTOR_TAG, "input"),
                                          array(SELECTOR_ATTR_VALUE, "type", "submit"))),
                              array("display" => "-button-submit", 
                                    "text-align" => "center", 
                                    "border" => "outset 2px",
                                    "background-color" => "#eeeeee")),
                        array(array(SELECTOR_SEQUENCE, array(array(SELECTOR_TAG, "input"),
                                                             array(SELECTOR_ATTR_VALUE, "type", "text"))),
                              array("display" => "-text")),
                        array(array(SELECTOR_TAG, "ins"),       array("text-decoration" => "underline")),
                        array(array(SELECTOR_TAG, "isindex"),   array("display" => "block")),
                        array(array(SELECTOR_TAG, "kbd")       ,array("font-family" => "monospace")),
                        // FIXME: generated boxes are too long...
                        array(array(SELECTOR_TAG, "legend"),    array("display" => "-legend",
                                                                      "background-color" => "white")),
                        array(array(SELECTOR_TAG, "li")        ,array("display" => "list-item")),
                        array(array(SELECTOR_TAG, "marquee"),   array("display" => "block",
                                                                      "overflow" => "hidden")),
                        array(array(SELECTOR_TAG, "menu"),      array("margin-left" => "1em")),
                        array(array(SELECTOR_TAG, "nobr"),      array("display" => "inline",
                                                                      "white-space" => "nowrap")),
                        array(array(SELECTOR_TAG, "noframes"),  array("display" => "none")),
                        array(array(SELECTOR_TAG, "object"),    array("display" => "block")),
                        array(array(SELECTOR_TAG, "ol"),        array("display" => "block", 
                                                                      "margin-left" => "1em", 
                                                                      "margin-top" => "1em", 
                                                                      "margin-bottom" => "1em")),
                        array(array(SELECTOR_SEQUENCE, array(array(SELECTOR_TAG, "ol"),
                                                             array(SELECTOR_PARENT,array(SELECTOR_TAG, "li")))), array("margin-top" => "0px", "margin-bottom" => "0px")),
                        array(array(SELECTOR_TAG, "option"),    array("display" => "none")),              
                        array(array(SELECTOR_TAG, "p"),         array("display" => "block", "margin" => "1em 0")),
                        array(array(SELECTOR_TAG, "pagebreak") ,array("display" => "block")),
                        array(array(SELECTOR_TAG, "param")     ,array("display" => "none")),
                        array(array(SELECTOR_TAG, "pre"),       array("display" => "block", 
                                                                      "font-family" => "monospace",
                                                                      "white-space" => "pre")),
                        array(array(SELECTOR_TAG, "samp"),      array("font-family" => "monospace")),
                        array(array(SELECTOR_TAG, "script"),    array("display" => "none")),
                        array(array(SELECTOR_TAG, "select"),    array("background-color" => "white", 
                                                                      "border" => "inset black 2px",
                                                                      "display" => "-select",
                                                                      "overflow" => "hidden",
                                                                      "padding" => "1pt",
                                                                      "margin" => "1px",
                                                                      "line-height" => 1)),
                        array(array(SELECTOR_TAG, "small"),     array("font-size" => "smaller")),
                        array(array(SELECTOR_TAG, "span"),      array("display" => "inline")),
                        array(array(SELECTOR_TAG, "strong"),    array("font-weight" => "bold")),
                        array(array(SELECTOR_TAG, "style"),     array("display" => "none")),                        
                        array(array(SELECTOR_TAG, "sup"),       array("display" => "inline", 
                                                                      "font-size" => "50%", 
                                                                      "vertical-align" => "super")),
                        array(array(SELECTOR_TAG, "sub"),       array("display" => "inline", 
                                                                      "font-size" => "50%", 
                                                                      "vertical-align" => "sub")),
                        array(array(SELECTOR_TAG, "table"),     array("display" => "table",
                                                                      "line-height" => 1.1)),
                        array(array(SELECTOR_TAG, "textarea"),  array("display" => "-textarea",
                                                                      "border" => "solid black 2px",
                                                                      "padding" => "3px", 
                                                                      "overflow" => "hidden",
                                                                      "width" => "15.3em", 
                                                                      "height" => "3em")),
                        array(array(SELECTOR_TAG, "tbody"),     array("display" => "-table-section")),
                        array(array(SELECTOR_TAG, "thead"),     array("display" => "-table-section")),
                        array(array(SELECTOR_TAG, "tfoot"),     array("display" => "-table-section")),
                        array(array(SELECTOR_TAG, "td"),        array("display" => "table-cell")),     
                        array(array(SELECTOR_TAG, "th"),        array("display" => "table-cell", 
                                                                      "font-weight" => "bold")),     
                        array(array(SELECTOR_TAG, "tr"),        array("display" => "table-row", 
                                                                      "vertical-align" => "middle")),     
                        array(array(SELECTOR_TAG, "tt"),        array("font-family" => "monospace")),
                        array(array(SELECTOR_TAG, "u") ,        array("text-decoration" => "underline")),
                        array(array(SELECTOR_TAG, "ul"),        array("display"         => "block", 
                                                                      "list-style-type" => "disc", 
                                                                      "padding-left"    => "40px", 
                                                                      "margin-top"      => "1em", 
                                                                      "margin-bottom"   => "1em")),
                        array(array(SELECTOR_TAG, "ol"),        array("display"         => "block", 
                                                                      "list-style-type" => "decimal", 
                                                                      "padding-left"    => "40px", 
                                                                      "margin-top"      => "1em", 
                                                                      "margin-bottom"   => "1em")),
                        array(array(SELECTOR_TAG, "pagebreak"), array("display"         => "block",
                                                                      "visibility"      => "hidden",
                                                                      "page-break-after"=> "always")),
                        array(array(SELECTOR_TAG, "var") ,      array("font-style" => "italic")),
                        array(array(SELECTOR_SEQUENCE, array(array(SELECTOR_TAG, "img"),
                                                             array(SELECTOR_PARENT_LOW_PRIORITY,array(SELECTOR_TAG, "a")))), array("border" => "solid blue 1px"))
                        );

$css = <<<EOF
/* nested lists have no top/bottom margins */
ul ul,   ul ol,   ul dir,   ul menu,   ul dl,
ol ul,   ol ol,   ol dir,   ol menu,   ol dl,
dir ul,  dir ol,  dir dir,  dir menu,  dir dl,
menu ul, menu ol, menu dir, menu menu, menu dl,
dl ul,   dl ol,   dl dir,   dl menu,   dl dl {
  margin-top: 0;
  margin-bottom: 0;
}

/* 2 deep unordered lists use a circle */
ol ul,   ul ul,   menu ul,   dir ul,
ol menu, ul menu, menu menu, dir menu,
ol dir,  ul dir,  menu dir,  dir dir {
  list-style-type: circle;
}

/* 3 deep (or more) unordered lists use a square */
ol ol ul,     ol ul ul,     ol menu ul,     ol dir ul,
ol ol menu,   ol ul menu,   ol menu menu,   ol dir menu,
ol ol dir,    ol ul dir,    ol menu dir,    ol dir dir,
ul ol ul,     ul ul ul,     ul menu ul,     ul dir ul,
ul ol menu,   ul ul menu,   ul menu menu,   ul dir menu,
ul ol dir,    ul ul dir,    ul menu dir,    ul dir dir,
menu ol ul,   menu ul ul,   menu menu ul,   menu dir ul,
menu ol menu, menu ul menu, menu menu menu, menu dir menu,
menu ol dir,  menu ul dir,  menu menu dir,  menu dir dir,
dir ol ul,    dir ul ul,    dir menu ul,    dir dir ul,
dir ol menu,  dir ul menu,  dir menu menu,  dir dir menu,
dir ol dir,   dir ul dir,   dir menu dir,   dir dir dir {
  list-style-type: square;
}
EOF
;

parse_css($css, new Pipeline());
global $g_css;
$g_css_defaults = array_merge($g_css_defaults, $g_css);

// Clear the global CSS object we've used to parse the CSS source above
$g_css = array();

for ($ctr = 0; $ctr < count($g_css_defaults); $ctr++) {
  $g_css_defaults[$ctr][2] = "";
  $g_css_defaults[$ctr][3] = $ctr;
};

global $g_css_defaults_obj;
$g_css_defaults_obj = new CSSObject;
foreach ($g_css_defaults as $rule) {
  $g_css_defaults_obj->add_rule($rule, new Pipeline());
}

?>